VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Order"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"32FA94C200D1"
'
Option Base 0
Option Explicit
Implements ObjectControl

Private oDBaskets As DpkgBaskets.DBaskets

Private oObjectContext As ObjectContext

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = True
End Function

Private Sub ObjectControl_Deactivate()
    Set oObjectContext = Nothing
    Set oDBaskets = Nothing
End Sub

Private Sub ObjectControl_Activate()
    On Error GoTo OCActivateErr
       
    Set oObjectContext = GetObjectContext()
    Set oDBaskets = oObjectContext.CreateInstance("DpkgBaskets.DBaskets")
    Exit Sub

OCActivateErr:
    Call RaiseError("OCActivate")

End Sub
Public Function BuildTransactionDetails(ByVal vOrderID As Variant) As Variant
    On Error GoTo BuildTransactionDetailsErr
        
    Dim vResponse As Variant
    Dim vBasket As Variant
    Dim vBasketItem As Variant
    Dim vPrice As Variant
    Dim vPromotionCode As Variant
    Dim vPromotionEndDate As Variant
    Dim vTodaysPrice As Variant
    Dim vShippingPrice As Variant
    Dim vTaxPrice As Variant
    Dim vTotalPrice As Variant
    Dim vNumItems As Variant
    Dim vOrderTotalPrice As Variant
    Dim vOrder As Collection
    Dim vOrderItem As Collection
            
    vOrderTotalPrice = 0
    vShippingPrice = 4
    Set vResponse = oDBaskets.GetBasketItems(vOrderID)
    If Not vResponse("error") Then
    
        Set vBasket = vResponse("items")
                  
        For Each vBasketItem In vBasket
            vPrice = vBasketItem("price")
            vPromotionCode = vBasketItem("promotioncode")
            vPromotionEndDate = vBasketItem("promotionenddate")
            vNumItems = vBasketItem("numitems")
            
            vTodaysPrice = AdjustTodaysPrice(vPrice, vPromotionCode, vPromotionEndDate)
            vTodaysPrice = Format(vTodaysPrice, "$###,##0.00")
            vBasketItem.Add vTodaysPrice, Key:="todaysprice"
            
            vTotalPrice = vNumItems * vPrice
            vTotalPrice = Format(vTotalPrice, "$###,##0.00")
            vBasketItem.Add vTotalPrice, Key:="totalprice"

            vOrderTotalPrice = vOrderTotalPrice + vTotalPrice
            vShippingPrice = vShippingPrice + (1.5 * CDec(vNumItems))
            
        Next
        Set vOrder = New Collection
            
        Set vOrderItem = New Collection
        vOrderItem.Add vBasket, Key:="basketitems"
        vOrder.Add vOrderItem, "basket"
        Set vOrderItem = Nothing
        
        Set vOrderItem = New Collection
        vTotalPrice = Format(vShippingPrice, "$###,##0.00")
        vOrderItem.Add vTotalPrice, Key:="totalprice"
        vOrderItem.Add "$4 and $1.5 per item", "details"
        vOrder.Add vOrderItem, "shipping"
        vOrderTotalPrice = vOrderTotalPrice + vShippingPrice
        Set vOrderItem = Nothing
        
        Set vOrderItem = New Collection
        vTaxPrice = vOrderTotalPrice * 0.125
        vTotalPrice = Format(vTaxPrice, "$###,##0.00")
        vOrderItem.Add vTotalPrice, Key:="totalprice"
        vOrderItem.Add "12.5%", "details"
        vOrder.Add vOrderItem, "tax"
        vOrderTotalPrice = vOrderTotalPrice + vTaxPrice
        Set vOrderItem = Nothing

        Set vOrderItem = New Collection
        vTotalPrice = Format(vOrderTotalPrice, "$###,##0.00")
        vOrderItem.Add vTotalPrice, Key:="totalprice"
        vOrder.Add vOrderItem, "ordertotal"
        Set vOrderItem = Nothing
    
        vOrder.Add False, Key:="error"
        
        Set vResponse = vOrder
    End If
    
    oObjectContext.SetComplete
    Set BuildTransactionDetails = vResponse
    
    Exit Function
    
BuildTransactionDetailsErr:
    oObjectContext.SetAbort
    Set BuildTransactionDetails = RaiseError("BuildTransactionDetails")

End Function

